local assets=
{ 
    Asset("ANIM", "anim/wand_g.zip"),
	Asset("ANIM", "anim/swap_wand_g.zip"),
    Asset("ATLAS", "images/inventoryimages/wand_g.xml"),
	Asset("IMAGE", "images/inventoryimages/wand_g.tex"),
}

local dam = 380

local function onattack_gauss(inst, owner, target)
    inst.SoundEmitter:PlaySound("shots/gunshot/gaussrifleshot")	
	owner.components.inventory:ConsumeByName("batteries", 1)
	
end

local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "swap_wand_g", "wand")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
		owner.components.combat.min_attack_period = 2
end

local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal")
		owner.components.combat.min_attack_period = 0
end



local function fn(colour)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter() 
    ---- 
    MakeInventoryPhysics(inst)
    
	
    anim:SetBank("wand")
    anim:SetBuild("wand_g")
    anim:PlayAnimation("idle")
		
	
	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(dam)
    inst.components.weapon:SetRange(30)
    inst.components.weapon:SetOnAttack(onattack_gauss)
    inst.components.weapon:SetProjectile("batteries")
	
		
	inst:AddComponent("inspectable")
		
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wand_g"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wand_g.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst.HasAmmo = function(inst, owner)
		if (owner and owner.components.inventory and owner.components.inventory:Has("batteries", 1))or (owner:HasTag("ai")) then
			return true
		end
		return false
	end
	
    return inst
end

return  Prefab("common/inventory/wand_g", fn, assets)